//+------------------------------------------------------------------+
#property copyright "Daniel Jose"
//+------------------------------------------------------------------+
struct st_Mem
{
    long    View_DateScale,
            View_PriceScale;
};
//+------------------------------------------------------------------+
void OnStart(void)
{
    st_Mem StyleGraphic;

    StyleGraphic = SAVE();

    ChartSetInteger(0, CHART_SHOW_DATE_SCALE, false);
    ChartSetInteger(0, CHART_SHOW_PRICE_SCALE, false);
    ChartRedraw();

    Sleep(2000);
    
    RESTORE(StyleGraphic);
}
//+------------------------------------------------------------------+
st_Mem SAVE(void)
{
    st_Mem local;

    local.View_DateScale = ChartGetInteger(0, CHART_SHOW_DATE_SCALE);
    local.View_PriceScale = ChartGetInteger(0, CHART_SHOW_PRICE_SCALE);

    return local;
}
//+------------------------------------------------------------------+
void RESTORE(const st_Mem &arg)
{
    ChartSetInteger(0, CHART_SHOW_DATE_SCALE, arg.View_DateScale);
    ChartSetInteger(0, CHART_SHOW_PRICE_SCALE, arg.View_PriceScale);

    ChartRedraw();
}
//+------------------------------------------------------------------+